//////////////////////////////////////////////
// ImageHandlingUtils.js
//
//////////////////////////////////////////////

/// Class ------------------------------------
	
nkWebUnitTests.ImageHandlingUtils = class ImageHandlingUtils
{
	static checkPixel (image, expectedColor, x, y, z = 0, mip = 0)
	{
		const pixel = image.getPixel(x, y, z, mip) ;
		const rDiff = Math.abs(pixel._x - expectedColor._x) ;
		const gDiff = Math.abs(pixel._y - expectedColor._y) ;
		const bDiff = Math.abs(pixel._z - expectedColor._z) ;
		const aDiff = Math.abs(pixel._w - expectedColor._w) ;

		let threshold = 1.0 ;

		if (nkImages.PixelFormatUtils.isFormatFloatingPoint(image.getFormat()))
			threshold = 0.004 ;

		if (rDiff > threshold || gDiff > threshold || bDiff > threshold || aDiff > threshold)
		{
			// Wrong color
			// Encode in base64 to display
			const bmpEncoded = nkImages.BmpEncoder.encodeBase(image) ;
			const base64Encoded = nkExport.Base64Encoder.encode(bmpEncoded) ;
			const base64Header = "data:image/bmp;base64," ;
			const base64Data = base64Header + base64Encoded.getDataAsString() ;

			// Append in window
			//const logDiv = document.getElementById("Log") ;
			const errorHeader = "<div>Wrong color while searching for equality.\n (x, y, z) | mip level : (" + x + ", " + y + ", " + z +") | " + mip + "</div>" ;
			const errorExpected = "<div>Expected color : " + expectedColor._x + ", " + expectedColor._y + ", " + expectedColor._z + ", " + expectedColor._w + "</div>" ;
			const errorPixel = "<div>Found color : " + pixel._x + ", " + pixel._y + ", " + pixel._z + ", " + pixel._w + " :</div>" ;
			const errorMessage = errorHeader + errorExpected + errorPixel + "<div> <image src=\"" + base64Data + "\"></image></div>"

			//console.log("Failure for image " + pixel._x + ", " + pixel._y + ", " + pixel._z + ", " + pixel._w) ;
			nkDebug.TestUtils.check(false, errorMessage) ;
		}

		// All good then
	}
}